﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Azyobuzi.りすにんぐついったー.Properties;
using System.Net;

namespace Azyobuzi.りすにんぐついったー
{
    public partial class LogForm : Form
    {
        static bool shown = false;

        public LogForm()
        {
            InitializeComponent();
            this.Icon = Resources.mainIco;
        }

        //インスタンスを作成せずログを表示させるメソッド
        private static LogForm f = new LogForm();
        public static void ShowForm()
        {
            f.Bounds = LogSettingsManager.Bounds;
            f.splitContainer1.SplitterDistance = Math.Max(f.splitContainer1.Panel1MinSize, LogSettingsManager.BottomPanel);
            f.columnHeader1.Width = LogSettingsManager.C1;
            f.columnHeader2.Width = LogSettingsManager.C2;
            f.columnHeader3.Width = LogSettingsManager.C3;
            f.columnHeader4.Width = LogSettingsManager.C4;

            f.Show();
            shown = true;

            f.toolStripButton1_Click(f.refreshToolStripButton, EventArgs.Empty);

            //if (Program.OverLogs())
            //{
            //    if (MessageBox.Show("ログが上限を超えました。古いログを削除しますか？", "上限オーバー", MessageBoxButtons.YesNo, MessageBoxIcon.Warning) == DialogResult.Yes)
            //    {
            //        for (int i = 0; i < LogSettingsManager.Log.Count - LogSettingsManager.MaxCount; i++)
            //        {
            //            LogSettingsManager.Log.RemoveAt(i);
            //        }
            //        f.toolStripButton1_Click(f.refreshToolStripButton, EventArgs.Empty);
            //    }
            //}
        }

        private void LogForm_Load(object sender, EventArgs e) {
            this.toolStripButton1_Click(this.refreshToolStripButton, EventArgs.Empty);
        }

        public void ListRefresh()
        {
            listView1.BeginUpdate(); //再描画禁止
            listView1.Items.Clear();

            for (int i = LogSettingsManager.Log.Count - 1; i >= 0; i--)
            {
                LogItem o = LogSettingsManager.Log[i];
                var lvi = new ListViewItem();
                
                string temp;
                if (o.Success) { temp = "成功"; } else { temp = "失敗"; }
                lvi.Text = temp;

                lvi.SubItems.Add(o.Date.ToString());

                if (o.Auto) { temp = "はい"; } else { temp = "いいえ"; }
                lvi.SubItems.Add(temp);

                lvi.SubItems.Add(o.Tweet);

                lvi.Tag = o;

                listView1.Items.Add(lvi);
            }

            listView1.EndUpdate();
       
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            ListRefresh();
        }

        private void listView1_SelectedIndexChanged(object sender, EventArgs e)
        {
            var si = listView1.SelectedItems;
            if (si.Count > 1) { tweetBox.Text = "複数選択"; delBtn.Enabled = false; return; }
            if (si.Count == 0) { tweetBox.Text = ""; delBtn.Enabled = false; return; }

            var o = (LogItem)listView1.SelectedItems[0].Tag;
            tweetBox.Text = o.Tweet;
            delBtn.Enabled = o.DeleteBtn;
        }

        private void delToolStripButton_Click(object sender, EventArgs e)
        {
            foreach (ListViewItem o in listView1.SelectedItems)
            {
                LogSettingsManager.Log.Remove((LogItem)o.Tag);
            }
            LogSettingsManager.Save();
            ListRefresh();
        }

        private void delBtn_Click(object sender, EventArgs e)
        {
            var o = (LogItem)listView1.SelectedItems[0].Tag;
            if (Program.twitterConnection.DeleteTweet(o.TweetID) == HttpStatusCode.OK)
            {
                o.DeleteBtn = false;
                delBtn.Enabled = false;
                ListRefresh();
            }
        }

        private void listView1_ColumnWidthChanged(object sender, ColumnWidthChangedEventArgs e) {
            if (!shown) return;
            LogSettingsManager.C1 = this.columnHeader1.Width;
            LogSettingsManager.C2 = this.columnHeader2.Width;
            LogSettingsManager.C3 = this.columnHeader3.Width;
            LogSettingsManager.C4 = this.columnHeader4.Width;
        }

        private void LogForm_BoundsChanged(object sender, EventArgs e) {
            if (!shown) return;
            LogSettingsManager.Bounds = this.Bounds;
        }

        private void splitContainer1_SplitterMoved(object sender, SplitterEventArgs e) {
            if (!shown) return;
            LogSettingsManager.BottomPanel = this.splitContainer1.SplitterDistance;
        }

        private void LogForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }

        private void helpToolStripButton_Click(object sender, EventArgs e)
        {
            Program.ShowWiki("つぶやきログ");
        }

        private void settingsToolStripButton_Click(object sender, EventArgs e)
        {
            var f = new MaxSettingsForm();
            f.ShowDialog(this);
            f.Dispose();
        }
    }
}
